/*
 * gc global variable provides access to GUI Composer infrastructure components and project information.
 * For more information, please see the Working with Javascript guide in the online help.
 */
var gc = gc || {};
gc.services = gc.services || {};

/*
 *  Boilerplate code for encoding and decoding data transmitted to / received from TI devices.
 */

var targetAccessErrorHandler = function (error) {
  if (error && error.message) {
    throw error.message;
  } else {
    throw error;
  }
};

var count = 0;

/**
 * This code implements the IPacketCodec interface.
 *
 * @constructor
 * @implements gc.databind.IPacketCodec
 */
CustomCodec = function () {};


var initCodec = function () {

  if (!gc || !gc.databind || !gc.databind.IPollingPacketCodec) {
    console.log("called initCodec but stuff is undefined");
    return;
  }

  // use default implementations of connect,disconnect,encode and decode functions:
  CustomCodec.prototype = new gc.databind.IPollingPacketCodec();

  CustomCodec.prototype.writeCmdTimer = null;
  CustomCodec.prototype.maxBitWidth = 16;
  CustomCodec.prototype.readCmdSymbols = null;
  CustomCodec.prototype.writeCmdSymbols = null;
  CustomCodec.prototype.pendingWriteCmds = null;
  CustomCodec.prototype.refreshListener = null;
  CustomCodec.prototype.preRefreshListener = null;
  CustomCodec.prototype.skipReadsUntilNextReadCmdFlagSet = false;
  CustomCodec.prototype.preRefreshTimeInMs = 30;
  CustomCodec.prototype.regBlocks = null;


  CustomCodec.prototype.setReadCmdFlag = function (reg) {
    if (reg) {
      var varsObj = {};
      varsObj['ManReadAddr'] = reg.addr;
      varsObj[reg.parentGroup.structReadCmdName] = 1;
      updateProcessQueue('W', reg.parentGroup.deviceObj, varsObj);
    } else {
      updateProcessQueue('W', 'gDRV8434_Obj', {
        ReadCmd: 1
      });
    }
  };

  CustomCodec.prototype.writeValue = function (symbol, value) {

    gc.console.log("CustomCodec", "CustomCodec.writeValue(" + symbol.regName + "," + value + ")");
    var structName = "";
    var deviceObj = "";
    var writeCmdName = "";
    if (symbol.parentGroup) {
      if (symbol.parentGroup.structName) {
        structName = symbol.parentGroup.structName;
      }
      if (symbol.parentGroup.deviceObj) {
        deviceObj = symbol.parentGroup.deviceObj;
      }
    }
    var regValue = +value;

    var varsObj = {};
    varsObj['ManWriteAddr'] = symbol.addr;
    varsObj['ManWriteData'] = value;
    varsObj[symbol.parentGroup.structWriteCmdName] = 1;
    // return gc.target.access.writeValue(deviceObj, varsObj).fail(targetAccessErrorHandler);
    return updateProcessQueue('W', deviceObj, varsObj);
  };

  // CustomCodec.prototype.readValue = function(symbol) {
  //     count++;
  //     var deferred = Q.defer();
  //     setTimeout(() => {

  //         if(count > 30){
  //             console.log('rejecting');
  //             deferred.reject('Error');
  //         }else{
  //             console.log('resolving');
  //             deferred.resolve(1);
  //         }
  //     });
  //     return deferred.promise;
  // };

  CustomCodec.prototype.readValue = function (symbol) {
    var structName = "";
    if (symbol.parentGroup && symbol.parentGroup.structName) {
      structName = symbol.parentGroup.structName + "."
    }
    var origValue = +symbol.value;
    if ((CustomCodec.prototype.pendingWriteCmds && CustomCodec.prototype.pendingWriteCmds.length > 0) || (CustomCodec.prototype.skipReadsUntilNextReadCmdFlagSet)) {
      gc.console.log("CustomCodec", "CustomCodec.readValue deferred for " + symbol.regName + " due to pending write.");
      return Q(origValue);
    }
    var _self = this;
    gc.console.debug("CustomCodec", "CustomCodec.readValue(" + symbol.regName + ")");
    structName = structName + symbol.regName;
    return updateProcessQueue('R', structName);

  };

  CustomCodec.prototype.onPreRefresh = function (oldValue, newValue, progress) {
    if (this.pendingWriteCmds && this.pendingWriteCmds.length > 0) {
      gc.console.log("CustomCodec", "skipping setting readCmd flag because of pending write(s)")
    } else {
      gc.console.debug("CustomCodec", "preRefresh: set ReadCmd flag");
      this.setReadCmdFlag();
    }
  };

  CustomCodec.prototype.onRefresh = function (oldValue, newValue, progress) {
    gc.console.log("CustomCodec", "refresh");
  };

  CustomCodec.prototype.connect = function (settings) {
    this.model = document.querySelector('ti-model-register');
    if (this.model) {
      var modelId = this.model.id;
      var refreshBind = gc.databind.registry.getBinding(modelId + '.$refresh_interval');
      if (refreshBind) {
        refreshBind.setPreRefreshInterval(this.preRefreshTimeInMs);
        this.preRefreshListener = new gc.databind.IChangedListener();
        this.preRefreshListener.onPreRefresh = this.onPreRefresh.bind(this);
        refreshBind.addPreRefreshListener(this.preRefreshListener);

        this.refreshListener = new gc.databind.IChangedListener();
        this.refreshListener.onRefresh = this.onRefresh.bind(this);
        refreshBind.addRefreshListener(this.refreshListener);

      }
      this.model.getRegisterViewInformation(0).then(function (deviceObj) {
        this.maxBitWidth = deviceObj.info.regsize;
        this.readCmdSymbols = [];
        this.regBlocks = deviceObj.regblocks;
        for (var i = 0; i < deviceObj.regblocks.length; i++) {
          var regBlock = deviceObj.regblocks[i];
          var structName = "";
          if (regBlock.structName && regBlock.structName.length > 0) {
            structName = regBlock.structName + ".";
          }
          if (regBlock.structReadCmdName) {
            var readCmdSymbol = structName + regBlock.structReadCmdName;
            this.readCmdSymbols.push(readCmdSymbol);
          }
          if (regBlock.structWriteCmdName) {
            var writeCmdSymbol = structName + regBlock.structWriteCmdName;
            this.writeCmdSymbols.push(writeCmdSymbol);
          }
        }
      }.bind(this));
    }
    var regPage = document.querySelector('#ti_widget_register_page');
    if (regPage) {
      regPage.preReadDelay = this.preRefreshTimeInMs;
      regPage.addEventListener('pre_read_reg', function (event) {
        this.setReadCmdFlag(event.detail.reg);
      }.bind(this));
    }

  };

  // registerCustomCodec has to be called right at startup in order for the codec to be recognized and used
  gc.console.log("CustomCodec", "CustomCodec: about to register...");
  var baseCodecs;
  gc.databind.registerCustomCodec("customRegModelCodec", CustomCodec, baseCodecs);

}



var cmdInProgress = false;
var commQueue = [];

setInterval(function () {
  if (!cmdInProgress) {
    if (commQueue.length > 0) {
      cmdInProgress = true;
      var thisCmd = commQueue.shift();
      if (thisCmd.processType === 'R') {
        gc.target.access.readValue(thisCmd.structName).then(function (val) {
          cmdInProgress = false;
          thisCmd.promise.resolve(val);
        }).fail(function (err) {
          thisCmd.promise.reject(err);
          cmdInProgress = false;
          commQueue = [];
        });
      } else if (thisCmd.processType === 'W') {
        if (thisCmd.value.ManWriteAddr != undefined) {
          setInProgressFlag(thisCmd.value.ManWriteAddr, true);
        }
        gc.target.access.writeValue(thisCmd.structName, thisCmd.value).then(function (val) {
          cmdInProgress = false;
          if (thisCmd.value.ManWriteAddr != undefined) {
            setInProgressFlag(thisCmd.value.ManWriteAddr, false);
          }
          thisCmd.promise.resolve();
        }).fail(function (err) {
          thisCmd.promise.reject(err);
          cmdInProgress = false;
          commQueue = [];
        });
      }
    }
  }
}, 10);

function setInProgressFlag(registerIndex, inProgressValue) {
  let keys = Object.keys(globalRegisterState.data);
  for (let key of keys) {
    if (globalRegisterState.data[key].index == registerIndex) {
      //globalRegisterState.data[key].inProgress = inProgressValue;
      if (inProgressValue) {
        globalRegisterState.setInProgressFlagToTrue.call(globalRegisterState.data[key]);
      } else {
        globalRegisterState.setInProgressFlagToFalse.call(globalRegisterState.data[key]);
      }
    }
  }
}

function updateProcessQueue(processType, processObj, updateVal) {
  var deferred = Q.defer();
  commQueue.push({
    promise: deferred,
    processType: processType,
    structName: processObj,
    value: updateVal
  });
  return deferred.promise;
}


var templateObj = document.querySelector('#template_obj');
if (templateObj) {
  initCodec();
} else {
  document.addEventListener('WebComponentsReady', initCodec);
}