/*
 * gc global variable provides access to GUI Composer infrastructure components and project information.
 * For more information, please see the Working with Javascript guide in the online help.
 */
var gc = gc || {};
gc.services = gc.services || {};

var globalStatusCopy = '';
var globalRegisterState = {
  setInProgressFlagToTrue: function () {
    this.inProgress = true;
    //console.log(`${this.name} inprogress flag is set to true`);
    if (this.inProgressTimer) {
      clearTimeout(this.inProgressTimer);
      this.inProgressTimer = null;
    }
  },
  setInProgressFlagToFalse: function () {
    if (this.inProgressTimer) {
      clearTimeout(this.inProgressTimer);
      this.inProgressTimer = null;
    }
    this.inProgressTimer = setTimeout(() => {
      this.inProgress = false;
      //console.log(`${this.name} inprogress flag is set to false`);
    }, 2000);
  },
  data: {
    fault_status_reg: {
      name: "fault_status_reg",
      index: 0,
      inProgress: false,
      inProgressTimer: undefined
    },
    diag_status1_reg: {
      name: "diag_status1_reg",
      index: 1,
      inProgress: false,
      inProgressTimer: undefined
    },
    diag_status2_reg: {
      name: "diag_status2_reg",
      index: 2,
      inProgress: false,
      inProgressTimer: undefined
    },
    ctrl1_reg: {
      name: "ctrl1_reg",
      index: 3,
      inProgress: false,
      inProgressTimer: undefined
    },
    ctrl2_reg: {
      name: "ctrl2_reg",
      index: 4,
      inProgress: false,
      inProgressTimer: undefined
    },
    ctrl3_reg: {
      name: "ctrl3_reg",
      index: 5,
      inProgress: false,
      inProgressTimer: undefined
    },
    ctrl4_reg: {
      name: "ctrl4_reg",
      index: 6,
      inProgress: false,
      inProgressTimer: undefined
    },
    ctrl5_reg: {
      name: "ctrl5_reg",
      index: 7,
      inProgress: false,
      inProgressTimer: undefined
    },
    ctrl6_reg: {
      name: "ctrl6_reg",
      index: 8,
      inProgress: false,
      inProgressTimer: undefined
    },
    ctrl7_reg: {
      name: "ctrl7_reg",
      index: 9,
      inProgress: false,
      inProgressTimer: undefined
    },
    ctrl8_reg: {
      name: "ctrl8_reg",
      index: 10,
      inProgress: false,
      inProgressTimer: undefined
    },
    ctrl9_reg: {
      name: "ctrl9_reg",
      index: 11,
      inProgress: false,
      inProgressTimer: undefined
    }
  }
}

/*
 *  Boilerplate code for creating computed data bindings
 */
document.addEventListener('gc-databind-ready', function () {

  var onDeviceConnectionChange = new gc.databind.IChangedListener();

  var getDeviceObj = function () {
    var deferred = Q.defer();

    setTimeout(function () {
      gc.target.access.readValue('gDRV8434_Obj').then(function (value) {
        deferred.resolve(value);
      }).fail(function (reason) {
        deferred.reject(reason);
      });
    }, 250);

    return deferred.promise;
  }

  var updateDeviceConnectionState = function (oldState, newState) {
    if (newState) {
      getDeviceObj().then(function (deviceObj) {
        let isDRV8434S = String.fromCharCode.apply(null,deviceObj.DeviceID).search("8434S");
        if (!isDRV8434S) {
          //updateRegisterMapBasedOnRevisionId();
          updateDeviceConnectionStateInallComponents(true, deviceObj.DeviceID);
        } else {
          updateDeviceConnectionStateInallComponents(false);
        }
      }).fail(function (reason) {
        updateDeviceConnectionStateInallComponents(false);
      })
    } else {
      updateDeviceConnectionStateInallComponents(false);
    }
  }

  var updateDeviceConnectionStateInallComponents = function (state, deviceID) {
    templateObj = document.querySelector('#template_obj');
    document.querySelector("#ti_tile_settings")._deviceConnectionChange(state);
    document.querySelector("#ti_custom_drv8434s_homepage")._deviceConnectionChange(state);
    if (state) {
      let deviceIDStr = String.fromCharCode.apply(null,deviceID);
      templateObj.$.ti_widget_eventlog_view.log("info", "DRV" + deviceIDStr + "-Q1 EVM connected");
    } else {
      gc.connectionManager.disconnect();
      templateObj.$.ti_widget_eventlog_view.log("info", "EVM disconnected");
    }
  }

  gc.autoDetectPortsFilter = function (transport, ports, info) {
    return ports.filter(function (port) {
      return port.manufacturer === "FTDI";
    });
  }

  // var updateRegisterMapBasedOnRevisionId = function() {
  //   var myModel = document.querySelector('#my_model');
  //   gc.target.access.writeValue('gDRV8434_Obj', {
  //     ReadCmd: 1
  //   }).then(function () {
  //     gc.target.access.readValue('gDeviceSpiReg').then(function (val) {
  //       if(val['ctrl8_reg'] == 0) {
  //         myModel.selectedDevice = 'drv8434s_v1_0_0';
  //       } else {
  //         myModel.selectedDevice = 'drv8434s_v1_0_1';
  //       }
  //     });
  //   });
  // }

  onDeviceConnectionChange.onValueChanged = updateDeviceConnectionState.bind(this);
  gc.databind.registry.getBinding('my_model.$target_connected').addChangedListener(onDeviceConnectionChange);
  /*
   *   Add custom computed value databindings here, using the following method:
   *
   *   function gc.databind.registry.bind(targetBinding, modelBinding, [getter], [setter]);
   *
   *   param targetBinding - single binding string or expression, or array of binding strings for multi-way binding.
   *   param modelBinding - single binding string or expression, or array of binding strings for multi-way binding.
   *   param getter - (optional) - custom getter function for computing the targetBinding value(s) based on modelBinding value(s).
   *   param setter - (optional) - custom setter function for computing the modelBinding value(s) based on targetBinding value(s).
   */

  // For example, a simple computed values based on simple expression
  // gc.databind.registry.bind('widget.id.propertyName', "targetVariable == 1 ? 'binding is one' : 'binding is not one'");

  // Or a custom two-way binding with custome getter and setter functions.  (setter is optional)  (getter only indicates one-way binding)
  // gc.databind.registry.bind('widget.id.propertyName', "targetVariable", function(value) { return value*5/9 + 32; }, function(value) { (return value-32)*9/5; });

  // Event 1 to n bindings
  /*
  gc.databind.registry.bind('widget.date.value',
      // dependant bindings needed in order to compute the date, in name/value pairs.
      {
          weekday: 'widget.dayOfWeek.selectedText',
          day: 'widget.dayOfMonth.value',
          month: 'widget.month.selectedText',
          year: 'widget.year.value'
      },
      // getter for date computation
      function(values)
      {
          // compute and return the string value to bind to the widget with id 'date'
          return values.weekday + ', ' + values.month + ' ' + values.day + ', ' + values.year;
      }
  );
  */

  var extendAboutBox = function () {
    var aboutBox = document.querySelector('ti-widget-aboutbox');
    if (aboutBox) {
      aboutBox.addEventListener('aboutbox_opening', function (event) {
        aboutBox.softwareManifestLink = "docs/manifest.html";
        aboutBox.licenseLink = "docs/license.pdf";
      });
    }
  };
  extendAboutBox();
});

function statusChangeHdlr() {
  if( !gc || !gc.connectionManager) {
     return; 
  }
  if (globalStatusCopy === gc.connectionManager.status) {
    return;
  }
  globalStatusCopy = gc.connectionManager.status;
  console.log('Status', gc.connectionManager.status);
  let settingsComponent = document.querySelector('#ti_tile_settings');
  if (!settingsComponent) {
    return;
  }
  if (gc.connectionManager.status === "connecting") {
    settingsComponent._showDeviceConnectionWarningPopup();
  } else {
    settingsComponent._closeDeviceConnectionWarningPopup();
  }
  if (gc.connectionManager.status === "disconnecting" || gc.connectionManager.status === "disconnected") {
    cmdInProgress = false;
    commQueue = [];
  }
}

document.addEventListener('WebComponentsReady', () => {
   gc.connectionManager.addEventListener('status-changed', statusChangeHdlr); 
});
statusChangeHdlr();

/*
 *  Boilerplate code for creating custom actions
 */
document.addEventListener('gc-nav-ready', function () {
  /*
   *   Add custom actions for menu items using the following api:
   *
   *   function gc.nav.registryAction(id, runable, [isAvailable], [isVisible]);
   *
   *   param id - uniquely identifies the action, and should correspond to the action property of the menuaction widget.
   *   param runable - function that performs the custom action.
   *   param isAvailable - (optional) - function called when the menu action is about to appear.  Return false to disable the action, or true to enable it.
   *   param isVisible - (optional) - function called when the menu action is about to appear.  Return false to hide the action, or true to make it visible.
   */

  // For example,
  // gc.nav.registerAction('myCustomCloseAction', function() { window.close(); }, function() { return true; }, function() { return true; });

  // Alternatively, to programmatically disable a menu action at any time use:
  // gc.nav.disableAction('myCustomCloseAction);    then enable it again using:  gc.nav.enableAction('myCustomCloseAction');

  gc.nav.registerAction('show_introduction', function () {
    if ((templateObj) && (templateObj.$)) {
      templateObj.$.ti_widget_vtabcontainer.selectedIndex = 0;
      templateObj.$.ti_widget_menuitem.hideFullMenu();
    }
  }, function () {
    return true;
  }, function () {
    return true;
  });
  gc.nav.registerAction('show_registers', function () {
    if ((templateObj) && (templateObj.$)) {
      templateObj.$.ti_widget_vtabcontainer.selectedIndex = 1;
      templateObj.$.ti_widget_menuitem.hideFullMenu();
    }
  }, function () {
    return true;
  }, function () {
    return true;
  });
  gc.nav.registerAction('show_motor_control', function () {
    if ((templateObj) && (templateObj.$)) {
      templateObj.$.ti_widget_vtabcontainer.selectedIndex = 2;
      templateObj.$.ti_widget_menuitem.hideFullMenu();
    }
  }, function () {
    return true;
  }, function () {
    return true;
  });

  gc.nav.registerAction('load_registers', function () {
    if ((templateObj) && (templateObj.$)) {
      gc.File.browseAndLoad(null, {
        bin: false
      }, function (contents, properties) {
        var regData = null;
        try {
          regData = JSON.parse(contents);
          if (regData) {
            templateObj.setRegisterData(regData);
            templateObj.$.ti_widget_eventlog_view.log("info", "Load Registers: loaded from :" + properties.localPath);
          }
        } catch (ex) {
          templateObj.logMsgAndNotify("error", "Load Registers: Could not parse file:" + ex, false, true);
        }

      });
    }
  }, function () {
    return true;
  }, function () {
    return true;
  });

  var saveText = function (fname, text, mime) {
    var blob = new Blob([text], {
      type: mime
    });
    saveAs(blob, fname);
    return false;
  }
  gc.nav.registerAction('save_registers', function () {
    if ((templateObj) && (templateObj.$)) {
      var regData = templateObj.getRegisterData();
      var regDataJson = JSON.stringify(regData);
      if (gc.desktop.isDesktop()) {
        gc.File.browseAndSave(regDataJson, 'regs.json', '*.json', function (result, errorInfo) {
          if (errorInfo) {
            templateObj.logMsgAndNotify("error", "Save Registers: " + errorInfo, false, true);
          } else if ((result) && (result.localPath)) {
            templateObj.$.ti_widget_eventlog_view.log("info", "Save Registers: saved to " + result.localPath);
          }

        });
      } else {
        saveText("regs.json", regDataJson, 'text/plain;charset=utf-8')
        templateObj.$.ti_widget_eventlog_view.log("info", "Save Registers: regs.json file downloaded");
      }
    }
  }, function () {
    return true;
  }, function () {
    return true;
  });

  gc.nav.registerAction('save_registers_as', function () {
    if ((templateObj) && (templateObj.$)) {
      var regData = templateObj.getRegisterData();
      var regDataJson = JSON.stringify(regData);
      if (gc.desktop.isDesktop()) {
        gc.File.browseAndSave(regDataJson, 'regs.json', '*.json', function (result, errorInfo) {
          if (errorInfo) {
            templateObj.logMsgAndNotify("error", "Save Registers As: " + errorInfo, false, true);
          } else if ((result) && (result.localPath)) {
            templateObj.$.ti_widget_eventlog_view.log("info", "Save Registers As: saved to " + result.localPath);
          }
        });
      } else {
        saveText("regs.json", regDataJson, 'text/plain;charset=utf-8')
        templateObj.$.ti_widget_eventlog_view.log("info", "Save Registers: regs.json file downloaded");
      }
    }
  }, function () {
    return true;
  }, function () {
    return true;
  });

  gc.nav.registerAction('open_log_pane', function () {
    if ((templateObj) && (templateObj.$)) {
      templateObj.$.ti_widget_eventlog_view.openView();
    }
  }, function () {
    return true;
  }, function () {
    return true;
  });

  gc.nav.registerAction('open_scripting_dialog', function () {
    if ((templateObj) && (templateObj.$)) {
      templateObj.$.scripting_dialog.removeAttribute('hidden');
      templateObj.$.scripting_dialog.open();
    }
  }, function () {
    return true;
  }, function () {
    return true;
  });

});

/*
 *  Boilerplate code for working with components in the application gist
 */


var initComplete = false;
var templateObj;
var registerModel;


// Wait for DOMContentLoaded event before trying to access the application template
var init = function () {
  templateObj = document.querySelector('#template_obj');

  // Wait for the template to fire a dom-change event to indicate that it has been 'stamped'
  // before trying to access components in the application.
  templateObj.addEventListener('dom-change', function () {
    if (initComplete) return;
    this.async(function () {
      initComplete = true;
      console.log("Application template has been stamped.");
      templateObj.$.ti_widget_toast.hideToast();
      templateObj.$.ti_widget_eventlog_view.log("info", "Application started.");
      registerModel = Polymer.dom(document).querySelector('ti-model-register');
      if (registerModel) {
        registerModel.addEventListener("usbHidModelReceivingData", function (event) {
          templateObj.logMsgAndNotify("debug", "Receiving data from target.", false, false);
        });
      } else {
        console.log("no ti-model-register component found in this application!")
      }

      // Now that the template has been stamped, you can use 'automatic node finding' $ syntax to access widgets.
      // e.g. to access a widget with an id of 'widget_id' you can use templateObj.$.widgetId

      // open the eventlog viewer when the user clicks on the book icon in the status bar:
      templateObj.$.ti_widget_eventlog_view.closeView(); // ensure that view states are in sync with application
      templateObj.$.ti_widget_statusbar.addEventListener("appiconclicked", function (event) {
        templateObj.$.ti_widget_eventlog_view.toggleView();
      });


      // Expand vtabcontainer nav bar when user clicks on menu icon or 'Menu' label
      templateObj.toggleMenu = function (event) {
        templateObj.$.ti_widget_vtabcontainer.isExpanded = !templateObj.$.ti_widget_vtabcontainer.isExpanded;
      };
      templateObj.$.ti_widget_icon_button_menu.addEventListener('click', templateObj.toggleMenu);
      templateObj.$.ti_widget_label_menu.addEventListener('click', templateObj.toggleMenu);

      if (templateObj.$.ti_widget_register_page) {
        // get the active device name from the register page
        // templateObj.$.ti_widget_menubar.productName = templateObj.$.ti_widget_register_page.deviceName;

        // called when the user clicks the Write Register button:
        templateObj.$.ti_widget_register_page.addEventListener("write_reg", function (event) {
          var detailsObj = event.detail;
          templateObj.logMsgAndNotify(detailsObj.statusType, detailsObj.statusMsg, false, true);
        }.bind(this));

        // called when the user clicks the Read Register button:
        templateObj.$.ti_widget_register_page.addEventListener("read_reg", function (event) {
          var detailsObj = event.detail;
          templateObj.logMsgAndNotify(detailsObj.statusType, detailsObj.statusMsg, false, true);
        }.bind(this));

        // called when the user clicks the Read All Registers button:
        templateObj.$.ti_widget_register_page.addEventListener("read_regs", function (event) {
          var detailsObj = event.detail;
          templateObj.logMsgAndNotify(detailsObj.statusType, detailsObj.statusMsg, false, true);
        }.bind(this));

        // called when the user changes the immediate / deferred mode
        templateObj.$.ti_widget_register_page.addEventListener("update_mode_changed", function (event) {
          var detailsObj = event.detail;
          templateObj.$.ti_widget_eventlog_view.log("info", "request to change update mode to " + detailsObj.mode.label);
        }.bind(this));

        // called when the user changes the auto read refresh rate
        templateObj.$.ti_widget_register_page.addEventListener("auto_read_config_changed", function (event) {
          var detailsObj = event.detail;
          templateObj.$.ti_widget_eventlog_view.log("info", "request to change automatic read interval to " + detailsObj.autoRead.label);
        }.bind(this));
      }

      var usbHidService = gc.services['ti-service-usbhid'];
      if (usbHidService) {
        usbHidService.addEventListener('usbHidError', function (event) {
          var detailsObj = event.detail;
          templateObj.logMsgAndNotify("error", detailsObj.info + ": " + detailsObj.error, false, true);
        })
      }

      templateObj.getRegisterData = function () {
        var regData = {
          signature: "oneui-register-data",
          data: []
        }
        var regBlocks = templateObj.$.ti_widget_register_page.regBlocks;
        for (var i = 0; i < regBlocks.length; i++) {
          var registersData = [];
          for (var r = 0; r < regBlocks[i].registers.length; r++) {
            var reg = regBlocks[i].registers[r];
            var regName = reg.name.toLowerCase();
            regName = regName.replace(/\&/g, "_");
            var item = {
              idx: r,
              id: regName,
              value: reg.value
            }
            registersData.push(item);
          }
          regData.data.push(registersData);
        }
        var strJson = JSON.stringify(regData);
        return strJson;
      };

      templateObj.setRegisterData = function (strJson) {
        var regData = JSON.parse(strJson);
        var ok = true;
        var regBlocks = templateObj.$.ti_widget_register_page.regBlocks;
        for (var b = 0; b < regBlocks.length; b++) {
          var registersData = [];
          for (var r = 0; r < regBlocks[b].registers.length; r++) {
            var reg = regBlocks[b].registers[r];
            var regName = reg.name.toLowerCase();
            regName = regName.replace(/\&/g, "_");
            item = regData.data[b][r];
            if (item.id === regName) {
              reg.value = item.value;
              var intValue = gc.utils.getValueFromHexString("" + reg.value);
              templateObj.$.ti_widget_register_page.writeValueToTargetRegister(intValue, null, b, r);
            } else {
              var msg = "load registers failed: register name mismatch (" + item.id + " does not match " + regName + ")";
              templateObj.logMsgAndNotify("warning", msg, false, true);
            }
          }

        }
      };

      templateObj.showToastMsg = function (msgType, msg, durationInSeconds) {
        templateObj.$.ti_widget_toast.hideToast();
        templateObj.$.ti_widget_toast.message = msg;
        switch (msgType.toLowerCase()) {
          case "error":
            templateObj.$.ti_widget_toast.iconName = "error";
            templateObj.$.ti_widget_toast.backgroundColor = "red";
            break;
          case "warning":
            templateObj.$.ti_widget_toast.iconName = "warning";
            templateObj.$.ti_widget_toast.backgroundColor = "orange";
            break;
          default:
            templateObj.$.ti_widget_toast.iconName = "check";
            templateObj.$.ti_widget_toast.backgroundColor = "teal";
            break;
        }
        templateObj.$.ti_widget_toast.duration = +durationInSeconds;
        templateObj.$.ti_widget_toast.showToast();
        console.log("toast msg [" + msgType + "]: " + msg);
      };

      templateObj.logMsgAndNotify = function (msgType, msg, showInStatusBar, showInToast) {
        var iconName = templateObj.$.ti_widget_eventlog_view.iconForItem(msgType);
        if (showInStatusBar) {
          var statusBar = gc.services['ti-widget-statusbar'];
          if (statusBar) {
            statusBar.statusString3 = msg;
            statusBar.setIcon(iconName);
          }
        }
        if (showInToast) {
          templateObj.showToastMsg(msgType, msg, 4);
        }
        templateObj.$.ti_widget_eventlog_view.log(msgType, msg);
      };
      // templateObj.$.ti_widget_label_learnmore.addEventListener("click", function(event) {
      //   templateObj.$.ti_widget_label_productname.fontColor = "#444";
      //   templateObj.$.ti_widget_label_productdesc.fontColor = "#444";
      //   templateObj.$.ti_widget_label_learnmore.setAttribute('hidden', true);
      //   templateObj.$.ti_widget_label_showless.removeAttribute('hidden');
      //   templateObj.$.ti_widget_vtab_home.style.backgroundColor = "white";
      //   templateObj.$.ti_widget_tabcontainer.selectedIndex = 1;
      // });
      // templateObj.$.ti_widget_label_showless.addEventListener("click", function(event) {
      //   templateObj.$.ti_widget_label_productname.fontColor = "white";
      //   templateObj.$.ti_widget_label_productdesc.fontColor = "white";
      //   templateObj.$.ti_widget_label_learnmore.removeAttribute('hidden');
      //   templateObj.$.ti_widget_label_showless.setAttribute('hidden', true);
      //   templateObj.$.ti_widget_vtab_home.style.backgroundColor = "rgb(20, 140, 156)";
      //   templateObj.$.ti_widget_tabcontainer.selectedIndex = 0;
      // });
      if (templateObj.$.ti_widget_button_connect) {
        templateObj.$.ti_widget_button_connect.addEventListener("click", function (event) {
          if (gc.connectionManager) {
            gc.connectionManager.connect();
          }
        });
      }


      templateObj.getRegisterData = function () {
        var regData = {
          signature: "oneui-register-data",
          data: []
        }
        var regBlocks = templateObj.$.ti_widget_register_page.regBlocks;
        for (var i = 0; i < regBlocks.length; i++) {
          var registersData = [];
          for (var r = 0; r < regBlocks[i].registers.length; r++) {
            var reg = regBlocks[i].registers[r];
            var regName = reg.name.toLowerCase();
            regName = regName.replace(/\&/g, "_");
            var item = {
              idx: r,
              id: regName,
              value: reg.value
            }
            registersData.push(item);
          }
          regData.data.push(registersData);
        }
        var strJson = JSON.stringify(regData);
        return strJson;
      };

      templateObj.setRegisterData = function (strJson) {
        var regData = JSON.parse(strJson);
        var ok = true;
        var regBlocks = templateObj.$.ti_widget_register_page.regBlocks;
        for (var b = 0; b < regBlocks.length; b++) {
          var registersData = [];
          for (var r = 0; r < regBlocks[b].registers.length; r++) {
            var reg = regBlocks[b].registers[r];
            var regName = reg.name.toLowerCase();
            regName = regName.replace(/\&/g, "_");
            item = regData.data[b][r];
            if (item.id === regName) {
              reg.value = item.value;
              var intValue = gc.utils.getValueFromHexString("" + reg.value);
              templateObj.$.ti_widget_register_page.writeValueToTargetRegister(intValue, null, b, r);
            } else {
              var msg = "load registers failed: register name mismatch (" + item.id + " does not match " + regName + ")";
              templateObj.logMsgAndNotify("warning", msg, false, true);
            }
          }

        }
      };

      templateObj.showToastMsg = function (msgType, msg, durationInSeconds) {
        templateObj.$.ti_widget_toast.hideToast();
        templateObj.$.ti_widget_toast.message = msg;
        switch (msgType.toLowerCase()) {
          case "error":
            templateObj.$.ti_widget_toast.iconName = "error";
            templateObj.$.ti_widget_toast.backgroundColor = "red";
            break;
          case "warning":
            templateObj.$.ti_widget_toast.iconName = "warning";
            templateObj.$.ti_widget_toast.backgroundColor = "orange";
            break;
          default:
            templateObj.$.ti_widget_toast.iconName = "check";
            templateObj.$.ti_widget_toast.backgroundColor = "teal";
            break;
        }
        templateObj.$.ti_widget_toast.duration = +durationInSeconds;
        templateObj.$.ti_widget_toast.showToast();
        console.log("toast msg [" + msgType + "]: " + msg);
      };

      templateObj.logMsgAndNotify = function (msgType, msg, showInStatusBar, showInToast) {
        var iconName = templateObj.$.ti_widget_eventlog_view.iconForItem(msgType);
        if (showInStatusBar) {
          var statusBar = gc.services['ti-widget-statusbar'];
          if (statusBar) {
            statusBar.statusString3 = msg;
            statusBar.setIcon(iconName);
          }
        }
        if (showInToast) {
          templateObj.showToastMsg(msgType, msg, 4);
        }
        templateObj.$.ti_widget_eventlog_view.log(msgType, msg);
      };
      if (templateObj.$.ti_widget_button_connect) {
        templateObj.$.ti_widget_button_connect.addEventListener("click", function (event) {
          if (gc.connectionManager) {
            gc.connectionManager.connect();
          }
        });
      }
    }, 1);

    const serialIO = document.querySelector("#serialIO");
    serialIO.defaultBaudRate = 115200;

    serialIO.addEventListener('selected-baud-rate-changed', function (event) {
      var baudRateSelect = document.querySelector("#baud_rate_select")
      var baudRateIndex = baudRateSelect.objValue.baudRateList.indexOf('' + event.detail.value);
      baudRateSelect.value = baudRateIndex;
    });

    // var readRegisterButton = document.querySelector("#read_register");
    // if (readRegisterButton) {
    //   readRegisterButton.disabled = true;
    // }

    // var readAllRegisterButton = document.querySelector("#read_all_registers");
    // if (readAllRegisterButton) {
    //   readAllRegisterButton.disabled = true;
    // }
  });
};

templateObj = document.querySelector('#template_obj');
if (templateObj) {
  init();
} else {
  document.addEventListener('DOMContentLoaded', init);
}