/*****************************************************************
 * Copyright (c) 2013-2014 Texas Instruments and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Paul Gingrich - Initial API and implementation
 *****************************************************************/
var gc = gc || {};
gc.databind = gc.databind || {};
gc.databind.internal = gc.databind.internal || {};
gc.databind.internal.expressionParser = gc.databind.internal.expressionParser || {};

(function() 
{
	var OP = '[]';
	
	gc.databind.internal.expressionParser.ArrayOperator = function(lookupBinding, indexBinding)
    {
        if (lookupBinding && indexBinding) 
        {
            this.lookupBinding = lookupBinding;
            this.indexBindings = [indexBinding];
                
            // add listener to index changes.
            indexBinding.addChangedListener(this);
        }
    };
    
	gc.databind.internal.expressionParser.ArrayOperator.prototype = new gc.databind.internal.expressionParser.AbstractLookupOperator(OP);

	gc.databind.internal.expressionParser.ArrayOperator.factory = (function() 
	{
		var Factory = function()
		{
		};
		
		Factory.prototype = new gc.databind.internal.expressionParser.AbstractLookupOperator.Factory(OP);
		
		Factory.prototype.createOperator = function()
		{
			return new gc.databind.internal.expressionParser.ArrayOperator();
		};
		
		Factory.prototype.parseLiteral = function(uri, factory, precedence)
		{
			return gc.databind.internal.expressionParser.ArrayLiteral.parseLiteral(uri);
		};
		
		return new Factory();
	}());
}());
